/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.planning;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import technology.rocketjump.undermount.entities.planning.JobAccessibilityTask;
import technology.rocketjump.undermount.entities.planning.PathfindingTask;
import technology.rocketjump.undermount.messaging.types.JobAccessibilityRequestMessage;
import technology.rocketjump.undermount.messaging.types.PathfindingRequestMessage;

public class BackgroundTaskManager
implements Telegraph,
Disposable {
    private ExecutorService executorService;
    private final MessageDispatcher messageDispatcher;
    private final int numberOtherCores;

    @Inject
    public BackgroundTaskManager(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.numberOtherCores = Runtime.getRuntime().availableProcessors() - 1;
        this.executorService = Executors.newFixedThreadPool(Math.max(2, this.numberOtherCores * 2));
        messageDispatcher.addListener(this, 400);
        messageDispatcher.addListener(this, 401);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 400: {
                PathfindingRequestMessage message = (PathfindingRequestMessage)msg.extraInfo;
                this.executorService.submit(new PathfindingTask(message));
                return true;
            }
            case 401: {
                JobAccessibilityRequestMessage message = (JobAccessibilityRequestMessage)msg.extraInfo;
                this.executorService.submit(new JobAccessibilityTask(message, this.messageDispatcher));
                return true;
            }
        }
        return false;
    }

    public void reset() {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
            this.executorService = Executors.newFixedThreadPool(Math.max(1, this.numberOtherCores));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 400);
        this.executorService.shutdownNow();
    }
}

